/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.DefaultClientInformationLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultClientInformationReplacementCondition;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.ClientInformationManager;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class StoreClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoreClientInformation.class);
    @NonnullAfterInit
    private ClientInformationManager clientInformationManager;
    @Nullable
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientInformation> clientInformationLookupStrategy = new DefaultClientInformationLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> replacementCondition = new DefaultClientInformationReplacementCondition();

    public void setRegistrationValidityPeriodStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.registrationValidityPeriodStrategy = strategy;
    }

    @Nonnull
    public ClientInformationManager getClientInformationManager() {
        this.checkComponentActive();
        return this.clientInformationManager;
    }

    public void setClientInformationManager(@Nonnull ClientInformationManager manager) {
        this.checkSetterPreconditions();
        this.clientInformationManager = (ClientInformationManager)Constraint.isNotNull((Object)manager, (String)"The client information manager cannot be null!");
    }

    public void setClientInformationLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientInformation> strategy) {
        this.checkSetterPreconditions();
        this.clientInformationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client information lookup strategy cannot be null");
    }

    public void setReplacementCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.replacementCondition = (Predicate)Constraint.isNotNull(condition, (String)"Replacement condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientInformationManager == null) {
            throw new ComponentInitializationException("ClientInformationManager cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation = this.clientInformationLookupStrategy.apply(profileRequestContext);
        if (clientInformation == null) {
            this.log.error("{} Unable to locate client information from the response message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        Duration lifetime = this.registrationValidityPeriodStrategy != null ? this.registrationValidityPeriodStrategy.apply(profileRequestContext) : null;
        boolean replace = this.replacementCondition.test(profileRequestContext);
        this.log.debug("{} Storing client information (replace = {})", (Object)this.getLogPrefix(), (Object)replace);
        try {
            if (lifetime != null && lifetime.isZero()) {
                this.log.debug("{} Registration won't expire, lifetime set to 0", (Object)this.getLogPrefix());
                assert (this.clientInformationManager != null);
                this.clientInformationManager.storeClientInformation(clientInformation, null, replace);
            } else {
                if (lifetime == null) {
                    this.log.debug("{} No registration validity period supplied, using default", (Object)this.getLogPrefix());
                    lifetime = Duration.ofHours(24L);
                }
                Instant expiration = Instant.now().plus(lifetime);
                this.log.debug("{} Registration will expire on {}", (Object)this.getLogPrefix(), (Object)expiration);
                assert (this.clientInformationManager != null);
                this.clientInformationManager.storeClientInformation(clientInformation, expiration, replace);
            }
        }
        catch (ClientInformationManagerException e) {
            this.log.error("{} Could not store the client information", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        this.log.info("{} Client information successfully stored for {}", (Object)this.getLogPrefix(), (Object)clientInformation.getID().getValue());
    }
}

