/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestSubjectLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetSubjectToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetSubjectToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> subjectLookupStrategy = new TokenRequestSubjectLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, SubjectType> subjectTypeStrategy;

    public void setSubjectTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectType> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.subjectTypeStrategy = (Function)Constraint.isNotNull(strategy, (String)"Subject type lookup strategy cannot be null");
    }

    public void setSubjectLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.subjectLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Subject lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String subject = this.subjectLookupStrategy.apply(profileRequestContext);
        if (subject == null) {
            this.log.error("{} Subject may not be null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setSubject(subject);
        if (this.subjectTypeStrategy != null) {
            oidcResponseContext.setSubjectType(SubjectType.PUBLIC.equals((Object)this.subjectTypeStrategy.apply(profileRequestContext)) ? "public" : "pairwise");
        }
    }
}

