/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.SectorIdentifierLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultSubjectTypeStrategy;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetSectorIdentifierForAttributeResolution
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetSectorIdentifierForAttributeResolution.class);
    @Nonnull
    private Function<ProfileRequestContext, String> sectorIdentifierLookupStrategy = new SectorIdentifierLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, SubjectType> subjectTypeLookupStrategy = new DefaultSubjectTypeStrategy();

    public void setSectorIdentifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.sectorIdentifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SectorIdentifierLookupStrategy lookup strategy cannot be null");
    }

    public void setSubjectTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectType> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.subjectTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectTypeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (SubjectType.PUBLIC.equals((Object)this.subjectTypeLookupStrategy.apply(profileRequestContext))) {
            ((AttributeResolutionContext)profileRequestContext.ensureSubcontext(AttributeResolutionContext.class)).setAttributeRecipientGroupID("public");
            this.log.debug("{} Attribute recipient group id set to value public for generating subject of type public", (Object)this.getLogPrefix());
            return;
        }
        String sectorIdentifier = this.sectorIdentifierLookupStrategy.apply(profileRequestContext);
        if (sectorIdentifier == null) {
            this.log.error("{} No sector identifier, pairwise subject cannot be generated", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingRedirectionURIs");
            return;
        }
        ((AttributeResolutionContext)profileRequestContext.ensureSubcontext(AttributeResolutionContext.class)).setAttributeRecipientGroupID(sectorIdentifier);
        this.log.debug("{} Attribute recipient group id set to sector identifier value {} for subject of type pairwise", (Object)this.getLogPrefix(), (Object)sectorIdentifier);
    }
}

