/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultAuthTimeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetAuthenticationTimeToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthenticationTimeToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Instant> authTimeLookupStrategy = new DefaultAuthTimeLookupFunction();

    public void setAuthTimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Instant> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.authTimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthTimeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Instant value = this.authTimeLookupStrategy.apply(profileRequestContext);
        if (value == null) {
            this.log.error("{} No authentication instant available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        this.log.debug("{} Setting authentication time to {}", (Object)this.getLogPrefix(), (Object)value);
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setAuthTime(value);
    }
}

