/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.oidc.profile.config.navigate.AcrClaimAlwaysEssentialLookupFunction;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.slf4j.Logger;

public class ProcessRequestedAuthnContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRequestedAuthnContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<ACR>> acrLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Predicate<ProfileRequestContext> acrAlwaysEssentialLookupStrategy = new AcrClaimAlwaysEssentialLookupFunction();
    @NonnullBeforeExec
    private AuthenticationContext authenticationContext;
    private List<ACR> acrValues;
    private ClaimsSetRequest.Entry acrClaim;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAcrLookupStrategy(@Nonnull Function<ProfileRequestContext, List<ACR>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.acrLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Acr lookup strategy cannot be null");
    }

    public void setAcrAlwaysEssentialLookupStrategy(@Nonnull Predicate<ProfileRequestContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.acrAlwaysEssentialLookupStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"AcrAlwaysEssentialLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.acrLookupStrategy == null) {
            throw new ComponentInitializationException("ACR lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClaimsSetRequest requestedIdTokenClaims;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.acrValues = this.acrLookupStrategy.apply(profileRequestContext);
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        OIDCClaimsRequest requestedClaims = oidcResponseContext.getRequestedClaims();
        if (requestedClaims != null && (requestedIdTokenClaims = requestedClaims.getIDTokenClaimsRequest()) != null) {
            for (ClaimsSetRequest.Entry entry : requestedIdTokenClaims.getEntries()) {
                if (!"acr".equals(entry.getClaimName())) continue;
                this.acrClaim = entry;
                break;
            }
        }
        if ((this.acrValues == null || this.acrValues.isEmpty()) && (this.acrClaim == null || this.acrClaim.getValuesAsListOfStrings() == null && this.acrClaim.getValueAsString() == null)) {
            this.log.debug("No acr values nor acr claim values in request, nothing to do");
            return false;
        }
        this.authenticationContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (this.authenticationContext == null) {
            this.log.error("{} No authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<AuthenticationContextClassReferencePrincipal> principals = new ArrayList<AuthenticationContextClassReferencePrincipal>();
        boolean isEssential = false;
        if (this.acrValues != null && !this.acrValues.isEmpty()) {
            for (Object acr : this.acrValues) {
                assert (acr != null);
                String acrValue = acr.getValue();
                assert (acrValue != null);
                this.log.debug("{} Located acr value {} in request", (Object)this.getLogPrefix(), (Object)acrValue);
                principals.add(new AuthenticationContextClassReferencePrincipal(acrValue));
            }
        } else if (this.acrClaim != null && this.acrClaim.getValueAsString() != null) {
            isEssential = this.acrClaim.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL);
            this.log.debug("{} Located {} acr claim {} in id token section of claims request", new Object[]{this.getLogPrefix(), this.acrClaim.getClaimRequirement().toString(), this.acrClaim.getValueAsString()});
            String acrClaimValue = this.acrClaim.getValueAsString();
            assert (acrClaimValue != null);
            principals.add(new AuthenticationContextClassReferencePrincipal(acrClaimValue));
        } else if (!(this.acrClaim == null || this.acrClaim.getValueAsString() != null && this.acrClaim.getValueAsString().isEmpty())) {
            isEssential = this.acrClaim.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL);
            for (Object acr : this.acrClaim.getValuesAsListOfStrings()) {
                this.log.debug("{} Located {} acr claim {} in id token section of claims request", new Object[]{this.getLogPrefix(), this.acrClaim.getClaimRequirement().toString(), acr});
                assert (acr != null);
                principals.add(new AuthenticationContextClassReferencePrincipal((String)acr));
            }
        }
        if (principals.isEmpty()) {
            this.log.debug("{} request did not contain any acr values, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (isEssential || this.acrAlwaysEssentialLookupStrategy.test(profileRequestContext)) {
            ProfileConfiguration profileConfig;
            RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
            ProfileConfiguration profileConfiguration = profileConfig = rpContext == null ? null : rpContext.getProfileConfig();
            if (profileConfig != null && profileConfig.isFeatureDisallowed(profileRequestContext, 1)) {
                this.log.warn("{} Incoming essential acr request disallowed by profile configuration", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
                return;
            }
            RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
            rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
            rpCtx.setRequestedPrincipals(principals);
            this.authenticationContext.addSubcontext((BaseContext)rpCtx, true);
            this.log.debug("{} Created requested principal context", (Object)this.getLogPrefix());
            return;
        }
        PreferredPrincipalContext ppCtx = new PreferredPrincipalContext();
        ppCtx.setPreferredPrincipals(principals);
        this.authenticationContext.addSubcontext((BaseContext)ppCtx, true);
        this.log.debug("{} Created preferred principal context", (Object)this.getLogPrefix());
    }
}

