/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class GenerateClientID
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenerateClientID.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> registrationTokenContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nullable
    private RelyingPartyContext rpCtx;
    @Nullable
    private OIDCClientRegistrationResponseContext oidcResponseCtx;
    @Nullable
    private OIDCClientRegistrationTokenClaimsContext registrationTokenCtx;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    private boolean xmlSafeIdentifier;

    public GenerateClientID() {
        Function orcls = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (orcls != null);
        this.oidcResponseContextLookupStrategy = orcls;
        this.registrationTokenContextLookupStrategy = new DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.xmlSafeIdentifier = true;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setRegistrationTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> strategy) {
        this.checkSetterPreconditions();
        this.registrationTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationTokenClaimsContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        assert (this.rpCtx != null);
        if (this.rpCtx.getProfileConfig() == null) {
            this.log.debug("{} No profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcResponseCtx == null) {
            this.log.debug("{} No OIDC client registration response context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.registrationTokenCtx = this.registrationTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.registrationTokenCtx != null && this.registrationTokenCtx.getClaimsSet() == null) {
            this.registrationTokenCtx = null;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RegistrationClaimsSet claimsSet;
        String clientId = null;
        if (this.registrationTokenCtx != null && (claimsSet = this.registrationTokenCtx.getClaimsSet()) != null) {
            clientId = claimsSet.getClientId();
        }
        if (clientId != null) {
            this.log.debug("{} Using client_id supplied by access token: {}", (Object)this.getLogPrefix(), (Object)clientId);
        } else {
            assert (this.idGenerator != null);
            clientId = this.idGenerator.generateIdentifier(this.xmlSafeIdentifier);
            this.log.debug("{} Created a new client ID: {}", (Object)this.getLogPrefix(), (Object)clientId);
        }
        assert (this.oidcResponseCtx != null);
        this.oidcResponseCtx.setClientId(clientId);
    }
}

