/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientRegistrationAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class BuildClientInformation
extends AbstractOIDCClientRegistrationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildClientInformation.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Secret clientSecret;
        boolean secretNeeded;
        OIDCClientRegistrationResponseContext oidcResponseContext = this.getRegistrationContext();
        String id = oidcResponseContext.getClientId();
        if (StringSupport.trimOrNull((String)id) == null) {
            this.log.error("{} No client ID in the OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        ClientID clientId = new ClientID(id);
        OIDCClientMetadata metadata = oidcResponseContext.getClientMetadata();
        if (metadata == null) {
            this.log.error("{} No client metadata in the OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        ClientAuthenticationMethod tokenAuthMethod = metadata.getTokenEndpointAuthMethod();
        boolean bl = secretNeeded = tokenAuthMethod == null || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        if (secretNeeded) {
            if (StringSupport.trimOrNull((String)oidcResponseContext.getClientSecret()) == null) {
                this.log.error("{} No required client secret in the OIDC response context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            Instant secretExpiresAt = oidcResponseContext.getClientSecretExpiresAt();
            if (secretExpiresAt != null) {
                this.log.warn("{} client secret expiration time {} is ignored", (Object)this.getLogPrefix(), (Object)secretExpiresAt);
            }
            clientSecret = new Secret(oidcResponseContext.getClientSecret());
        } else {
            clientSecret = null;
        }
        OIDCClientInformation clientInformation = new OIDCClientInformation(clientId, new Date(), metadata, clientSecret);
        oidcResponseContext.setClientInformation(clientInformation);
        this.log.info("{} Client information successfully populated to the response context", (Object)this.getLogPrefix());
    }
}

