/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.langtag.LangTag;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddTosUrisToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddTosUrisToClientMetadata.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Map uris = this.getInputMetadata().getTermsOfServiceURIEntries();
        if (uris == null) {
            this.log.debug("{} No tos uris defined in the request", (Object)this.getLogPrefix());
            return;
        }
        for (LangTag tag : uris.keySet()) {
            this.log.debug("{} Added a tos URI {} for language {}", new Object[]{this.getLogPrefix(), uris.get(tag), tag});
            this.getOutputMetadata().setTermsOfServiceURI((URI)uris.get(tag), tag);
        }
    }
}

