/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddTokenDeliveryAttributesToClaimsSet
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddTokenDeliveryAttributesToClaimsSet.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> responseClaimsSetLookupStrategy = new DefaultResponseClaimsSetLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nullable
    private ClaimsSet claimsSet;
    private boolean targetIDToken;
    @Nullable
    private OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;

    AddTokenDeliveryAttributesToClaimsSet() {
        Function tccls = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (tccls != null);
        this.tokenClaimsContextLookupStrategy = tccls;
    }

    public void setTargetIDToken(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.targetIDToken = flag;
    }

    public void setResponseClaimsSetLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.responseClaimsSetLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response Claims Set lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.claimsSet = this.responseClaimsSetLookupStrategy.apply(profileRequestContext);
        if (this.claimsSet == null) {
            this.log.error("{} No claims set to fill", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (this.tokenClaimsCtx == null) {
            this.log.debug("{} No token delivery claims context, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.tokenClaimsCtx != null);
        ClaimsSet tokenClaims = this.tokenClaimsCtx.getClaims();
        assert (this.claimsSet != null);
        this.claimsSet.putAll(tokenClaims);
        if (this.targetIDToken) {
            assert (this.tokenClaimsCtx != null);
            ClaimsSet idTokenClaims = this.tokenClaimsCtx.getIdtokenClaims();
            assert (this.claimsSet != null);
            this.claimsSet.putAll(idTokenClaims);
        } else {
            assert (this.tokenClaimsCtx != null);
            ClaimsSet userInfoClaims = this.tokenClaimsCtx.getUserinfoClaims();
            assert (this.claimsSet != null);
            this.claimsSet.putAll(userInfoClaims);
        }
        if (this.log.isDebugEnabled()) {
            assert (this.claimsSet != null);
            String claimsSetString = this.claimsSet.toJSONObject().toJSONString();
            this.log.debug("{} claims set after adding token delivery claims {}", (Object)this.getLogPrefix(), (Object)claimsSetString);
        }
    }
}

