/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddSubjectTypeToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddSubjectTypeToClientMetadata.class);
    private SubjectType defaultSubjectType = SubjectType.PUBLIC;

    public void setDefaultSubjectType(SubjectType subjectType) {
        this.defaultSubjectType = (SubjectType)Constraint.isNotNull((Object)subjectType, (String)"The default subjectType cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectType requestedType = this.getInputMetadata().getSubjectType();
        if (requestedType == null) {
            this.log.debug("{} No subject type requested, using default {}", (Object)this.getLogPrefix(), (Object)this.defaultSubjectType);
            this.getOutputMetadata().setSubjectType(this.defaultSubjectType);
        } else {
            this.getOutputMetadata().setSubjectType(requestedType);
        }
    }
}

