/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.MetadataStatementsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddMetadataStatementToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddMetadataStatementToClientMetadata.class);
    private Map<String, String> statements;
    private Function<ProfileRequestContext, Map<String, String>> statementsLookupFunction = new MetadataStatementsLookupFunction();

    public void setMetadataStatements(Map<String, String> metadataStatements) {
        this.statements = (Map)Constraint.isNotNull(metadataStatements, (String)"The metadata statements cannot be null!");
    }

    public void setStatementsLookupFunction(Function<ProfileRequestContext, Map<String, String>> function) {
        this.statementsLookupFunction = (Function)Constraint.isNotNull(function, (String)"The metadata statements lookup function cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Map<String, String> incomingStatements = this.statementsLookupFunction.apply(profileRequestContext);
        if (incomingStatements == null) {
            this.log.debug("{} No incoming metadata statements, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        for (String foKey : this.statements.keySet()) {
            if (!incomingStatements.containsKey(foKey)) continue;
            this.log.debug("{} Using {} as the federation in the response", (Object)this.getLogPrefix(), (Object)foKey);
            JSONObject statement = new JSONObject();
            statement.put((Object)foKey, (Object)this.statements.get(foKey));
            this.getOutputMetadata().setCustomField("metadata_statements", (Object)statement);
            return;
        }
        this.log.error("{} Could not find any trusted federations from the incoming message", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((Object)((Object)this), (String)"InvalidMessage");
    }
}

