/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.oidc.profile.config.navigate.AudienceRestrictionsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.IDTokenLifetimeLookupFunction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddIDTokenShell
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddIDTokenShell.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> audienceRestrictionsLookupStrategy = new AudienceRestrictionsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> idTokenLifetimeLookupStrategy = new IDTokenLifetimeLookupFunction();
    @Nullable
    private String issuerId;
    @Nullable
    private Collection<String> audiences;
    @Nullable
    private Duration lifetime;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setAudienceRestrictionsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.audienceRestrictionsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Audience restriction lookup strategy cannot be null");
    }

    public void setIDTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ID token lifetime lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.warn("{} No issuer returned for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        Collection<String> restrictions = this.audienceRestrictionsLookupStrategy.apply(profileRequestContext);
        if (restrictions == null || restrictions.isEmpty()) {
            this.log.warn("{} No audiences returned for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.audiences = restrictions;
        this.lifetime = this.idTokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.lifetime == null) {
            this.log.warn("{} No lifetime supplied for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<Audience> aud = new ArrayList<Audience>();
        assert (this.audiences != null);
        for (String audience : this.audiences) {
            aud.add(new Audience(audience));
        }
        Date exp = Date.from(Instant.now().plus(this.lifetime));
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        IDTokenClaimsSet idToken = new IDTokenClaimsSet(new Issuer(this.issuerId), new Subject(oidcResponseContext.getSubject()), aud, exp, new Date());
        String sid = oidcResponseContext.getSessionId();
        if (StringSupport.trimOrNull((String)sid) != null) {
            idToken.setSessionID(new SessionID(sid));
        }
        this.log.debug("{} Setting ID token shell to response context {}", (Object)this.getLogPrefix(), (Object)idToken.toJSONObject().toJSONString());
        oidcResponseContext.setIDToken(idToken);
    }
}

