/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.TokenRequestClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationRequestAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidatePushedAuthorizationClientIDMatch
extends AbstractOAuthAuthorizationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidatePushedAuthorizationClientIDMatch.class);
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy = new TokenRequestClientIDLookupFunction();

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientID authenticatedClientId = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
        if (authenticatedClientId == null) {
            this.log.warn("{} No client ID that was used in client authentication could be resolved", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        if (authorizationRequest == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} Could not resolve AuthorizationRequest message from request", (Object)this.getLogPrefix());
            return;
        }
        ClientID requestClientId = authorizationRequest.getClientID();
        if (!authenticatedClientId.equals((Object)requestClientId)) {
            this.log.warn("{} The client ID used in authentication {} did not match with one in request {}", new Object[]{this.getLogPrefix(), authenticatedClientId, requestClientId});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
    }
}

