/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Request;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2DPoPProofContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl.DPoPProofNonceJWTValidationException;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.DPoPProofClaimsValidatorLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.DPoPProofNonceGeneratorLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateDPoPProof
extends AbstractOIDCRequestAction<Request> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateDPoPProof.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = new DPoPProofClaimsValidatorLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Function<ProfileRequestContext, String>> nonceGeneratorLookupStrategy = new DPoPProofNonceGeneratorLookupFunction();
    @Nullable
    private ClaimsValidator claimsValidator;

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setDpopProofNonceGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<ProfileRequestContext, String>> strategy) {
        this.nonceGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OAuth2DPoPProofContext proofContext = (OAuth2DPoPProofContext)profileRequestContext.ensureInboundMessageContext().getSubcontext(OAuth2DPoPProofContext.class);
        if (proofContext == null || proofContext.getDpopProof() == null) {
            this.log.debug("{} No DPoP Proof found from the response context, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.claimsValidator = this.claimsValidatorLookupStrategy.apply(profileRequestContext);
        if (this.claimsValidator == null) {
            this.log.error("{} Could not resolve claims validator via lookup", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String jwkThumbprint;
        JWTClaimsSet jwtClaimsSet;
        OAuth2DPoPProofContext proofContext = (OAuth2DPoPProofContext)profileRequestContext.ensureInboundMessageContext().ensureSubcontext(OAuth2DPoPProofContext.class);
        SignedJWT dpopProof = proofContext.getDpopProof();
        assert (dpopProof != null);
        try {
            jwtClaimsSet = dpopProof.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.warn("{} Could not parse claims set of DPoP Proof", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        JWSHeader header = dpopProof.getHeader();
        if (!new JOSEObjectType("dpop+jwt").equals((Object)header.getType())) {
            this.log.warn("{} Unexpected 'typ' parameter value {}", (Object)this.getLogPrefix(), (Object)header.getType());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        JWK jwk = header.getJWK();
        if (jwk == null) {
            this.log.warn("{} No value found from 'jwk' parameter value {}", (Object)this.getLogPrefix(), (Object)header.getType());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        if (jwk.isPrivate()) {
            this.log.warn("{} Private key exists in 'jwk' parameter value {}", (Object)this.getLogPrefix(), (Object)header.getType());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        assert (jwtClaimsSet != null);
        try {
            assert (this.claimsValidator != null);
            this.claimsValidator.validate(jwtClaimsSet, profileRequestContext);
        }
        catch (DPoPProofNonceJWTValidationException e) {
            this.log.debug("{} DPoP Proof JWT nonce validation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            this.handleNonceValidationFailure(profileRequestContext);
            return;
        }
        catch (JWTValidationException e) {
            this.log.warn("{} DPoP Proof JWT validation failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        try {
            jwkThumbprint = jwk.computeThumbprint().toString();
        }
        catch (JOSEException e) {
            this.log.error("{} Could not calculate thumbprint for the JWK", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        proofContext.setValidatedDpopProofThumbprint(jwkThumbprint);
        this.log.trace("{} JWK thumbprint stored in the context", (Object)this.getLogPrefix());
    }

    protected void handleNonceValidationFailure(@Nonnull ProfileRequestContext profileRequestContext) {
        Function<ProfileRequestContext, String> nonceGenerator = this.nonceGeneratorLookupStrategy.apply(profileRequestContext);
        if (nonceGenerator == null) {
            this.log.error("{} Could not fetch nonce generator", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        String nonce = nonceGenerator.apply(profileRequestContext);
        if (nonce == null) {
            this.log.error("{} Could not create new nonce via generator", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        HttpServletResponse servletResponse = this.getHttpServletResponse();
        if (servletResponse == null) {
            this.log.error("{} Could not fetch HttpServletResponse", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
        } else {
            servletResponse.addHeader("DPoP-Nonce", nonce);
            this.log.debug("{} DPoP-Nonce header {} added to the response", (Object)this.getLogPrefix(), (Object)nonce);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPNonceInvalid");
        }
    }
}

