/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Request;
import jakarta.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2DPoPProofContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeDPoPProofContext
extends AbstractOIDCRequestAction<Request> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(InitializeDPoPProofContext.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OAUTH2");
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> requireDpopProofCondition;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setRequireDpopProofCondition(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.requireDpopProofCondition = (Predicate)Constraint.isNotNull(predicate, (String)"DPoP proof enforced predicate annot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.requireDpopProofCondition == null) {
            throw new ComponentInitializationException("DPoP proof enforced predicate cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        if (httpServletRequest == null) {
            this.log.error("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        boolean valueExists = httpServletRequest.getHeader("DPoP") != null;
        boolean requireDpopProof = this.requireDpopProofCondition.test(profileRequestContext);
        if (!valueExists) {
            if (!requireDpopProof) {
                this.log.debug("{} No optional DPoP Proof header values exists, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
            this.log.warn("{} No mandatory DPoP Proof header value exists", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofRequired");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        assert (httpServletRequest != null);
        String dpopProofValue = this.getSingleValueOrNull(httpServletRequest.getHeaders("DPoP"));
        if (dpopProofValue == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofRequired");
            return;
        }
        OAuth2DPoPProofContext proofContext = (OAuth2DPoPProofContext)profileRequestContext.ensureInboundMessageContext().ensureSubcontext(OAuth2DPoPProofContext.class);
        try {
            SignedJWT jwt = SignedJWT.parse((String)dpopProofValue);
            if (jwt != null) {
                proofContext.setDpopProof(jwt);
                this.log.debug("{} DPoP Proof value {} stored into the response context", (Object)this.getLogPrefix(), (Object)dpopProofValue);
                this.doProtocolLog(profileRequestContext, (JWT)jwt, "DPoP proof JWT payload contents");
                return;
            }
            this.log.warn("{} DPoP Proof value {} parsing returned a null JWT", (Object)this.getLogPrefix(), (Object)dpopProofValue);
        }
        catch (ParseException e) {
            this.log.warn("{} Could not parse the DPoP Proof value {} into a signed JWT", new Object[]{this.getLogPrefix(), dpopProofValue, e});
        }
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
    }

    @Nullable
    protected String getSingleValueOrNull(@Nullable Enumeration<String> enumeration) {
        if (enumeration == null) {
            this.log.warn("{} No mandatory DPoP Proof header value exists", (Object)this.getLogPrefix());
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        assert (list != null);
        if (list.isEmpty()) {
            this.log.warn("{} No mandatory DPoP Proof header value exists", (Object)this.getLogPrefix());
            return null;
        }
        if (list.size() > 1) {
            this.log.warn("{} More than one DPoP Proof header value exists, not allowed", (Object)this.getLogPrefix());
            return null;
        }
        return (String)list.get(0);
    }

    protected void doProtocolLog(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull JWT jwt, @Nonnull String messagePrefix) {
        try {
            assert (this.objectMapper != null);
            this.protocolMessageLog.trace("{}:\n{}", (Object)messagePrefix, (Object)ResponseUtil.getJwtProtocolMessage(jwt, this.objectMapper));
        }
        catch (ParseException e) {
            this.log.error("{} Could not produce the protocol logger message", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
        }
    }
}

