/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2PushedAuthorizationRequestContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationRequestAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class DeserializePushedRequest
extends AbstractOAuthAuthorizationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DeserializePushedRequest.class);
    @Nonnull
    private Function<ProfileRequestContext, OAuth2PushedAuthorizationRequestContext> pushedAuthorizationRequestContextLookupStrategy;
    @Nonnull
    private List<BiFunction<ProfileRequestContext, URI, Map<String, Object>>> pushedAuthorizationRequestUriDeserializers;
    @NonnullBeforeExec
    private URI requestUri;

    public DeserializePushedRequest() {
        Function parcls = new ChildContextLookup(OAuth2PushedAuthorizationRequestContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (parcls != null);
        this.pushedAuthorizationRequestContextLookupStrategy = parcls;
        this.pushedAuthorizationRequestUriDeserializers = CollectionSupport.emptyList();
    }

    public void setPushedAuthorizationRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2PushedAuthorizationRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.pushedAuthorizationRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Pushed authorization request context lookup strategy cannot be null");
    }

    public void setPushedAuthorizationRequestUriDeserializers(@Nonnull List<BiFunction<ProfileRequestContext, URI, Map<String, Object>>> deserializers) {
        this.checkSetterPreconditions();
        this.pushedAuthorizationRequestUriDeserializers = (List)Constraint.isNotNull(deserializers, (String)"List of request_uri deserializers cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestUri = Optional.ofNullable(this.getAuthorizationRequest()).map(request -> request.getRequestURI()).orElse(null);
        if (this.requestUri == null) {
            this.log.debug("{} No request_uri value found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (BiFunction<ProfileRequestContext, URI, Map<String, Object>> deserializer : this.pushedAuthorizationRequestUriDeserializers) {
            Map<String, Object> claimsSet = deserializer.apply(profileRequestContext, this.requestUri);
            if (claimsSet == null || claimsSet.isEmpty()) continue;
            this.log.trace("{} Storing claims set {}", (Object)this.getLogPrefix(), claimsSet);
            this.pushedAuthorizationRequestContextLookupStrategy.apply(profileRequestContext).setClaimsSet(CollectionSupport.copyToMap(claimsSet));
            this.log.debug("{} Pushed authorization request successfully deserialized and stored", (Object)this.getLogPrefix());
            return;
        }
    }
}

