/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.metadata.MetadataLookupExtensionContext;
import net.shibboleth.idp.plugin.oidc.op.metadata.MetadataLookupExtensionFlowDescriptor;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class SelectMetadataLookupExtensionFlow
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectMetadataLookupExtensionFlow.class);
    @Nonnull
    private Function<ProfileRequestContext, MetadataLookupExtensionContext> metadataLookupExtensionContextCreationStrategy;
    @Nullable
    private Collection<MetadataLookupExtensionFlowDescriptor> availableFlows;
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> profileIDLookupStrategy;
    @NonnullBeforeExec
    private MetadataLookupExtensionContext metadataLookupExtensionContext;

    public SelectMetadataLookupExtensionFlow() {
        Function mleccs = new ChildContextLookup(MetadataLookupExtensionContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (mleccs != null);
        this.metadataLookupExtensionContextCreationStrategy = mleccs;
        this.clientIDLookupStrategy = new DefaultClientIDLookupFunction();
    }

    public void setMetadataLookupExtensionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, MetadataLookupExtensionContext> strategy) {
        this.checkSetterPreconditions();
        this.metadataLookupExtensionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"MetadataLookupExtensionContextCreationStrategy cannot be null");
    }

    public void setAvailableFlows(@Nullable Collection<MetadataLookupExtensionFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.availableFlows = flows;
    }

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    public void setProfileIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.profileIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileIDLookupStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.profileIDLookupStrategy == null) {
            throw new ComponentInitializationException("ProfileIDLookupStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.metadataLookupExtensionContext = this.metadataLookupExtensionContextCreationStrategy.apply(profileRequestContext);
        if (this.metadataLookupExtensionContext == null) {
            this.log.error("{} Could not create the metadata lookup extension context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.availableFlows == null || this.availableFlows.isEmpty()) {
            this.log.debug("{} No available metadata lookup extension flows, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.metadataLookupExtensionContext.getClientId() == null) {
            ClientID clientId = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
            if (clientId == null) {
                this.log.debug("{} Could not resolve client ID to be looked up", (Object)this.getLogPrefix());
            } else {
                this.metadataLookupExtensionContext.setClientId(clientId.getValue());
            }
        }
        if (this.metadataLookupExtensionContext.getProfileId() == null) {
            String profileId = this.profileIDLookupStrategy.apply(profileRequestContext);
            if (profileId == null) {
                this.log.debug("{} Could not resolve profile ID to be used", (Object)this.getLogPrefix());
            } else {
                this.metadataLookupExtensionContext.setProfileId(profileId);
            }
        }
        for (MetadataLookupExtensionFlowDescriptor flow : this.availableFlows) {
            this.log.trace("{} Checking flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
            if (this.metadataLookupExtensionContext.getAttemptedFlows().contains(flow)) {
                this.log.debug("{} Flow {} has already been attempted", (Object)this.getLogPrefix(), (Object)flow.getId());
                continue;
            }
            this.log.debug("{} Selecting flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
            this.metadataLookupExtensionContext.getAttemptedFlows().add(flow);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.ensureId());
            return;
        }
        this.log.debug("{} No flows available to choose from", (Object)this.getLogPrefix());
    }
}

