/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.impl;

import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class FrontChannelLogoutPropagationResponse
implements Response {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FrontChannelLogoutPropagationResponse.class);
    @Nonnull
    private final String frontChannelLogoutUri;
    @Nullable
    private final String issuer;
    @Nullable
    private final String sessionId;

    public FrontChannelLogoutPropagationResponse(@Nonnull String uri) {
        this(uri, null, null);
    }

    public FrontChannelLogoutPropagationResponse(@Nonnull String uri, @Nullable String iss, @Nullable String sid) {
        this.frontChannelLogoutUri = Constraint.isNotEmpty((String)uri, (String)"Front-channel logout URI cannot be empty");
        this.issuer = StringSupport.trimOrNull((String)iss);
        this.sessionId = StringSupport.trimOrNull((String)sid);
        if (this.issuer == null && this.sessionId != null || this.issuer != null && this.sessionId == null) {
            throw new ConstraintViolationException("Issuer and session ID must be both present or absent");
        }
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse response = new HTTPResponse(302);
        try {
            URI uri = this.issuer != null && this.sessionId != null ? (this.frontChannelLogoutUri.contains("?") ? new URI(this.serializeParameters(this.frontChannelLogoutUri + "&")) : new URI(this.serializeParameters(this.frontChannelLogoutUri + "?"))) : new URI(this.frontChannelLogoutUri);
            response.setLocation(uri);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            this.log.error("Could not construct an URI object", (Throwable)e);
        }
        return response;
    }

    @Nonnull
    protected String serializeParameters(@Nonnull String prefix) throws UnsupportedEncodingException {
        if (this.issuer != null && this.sessionId != null) {
            return prefix + "iss=" + URLEncoder.encode(this.issuer, "UTF-8") + "&sid=" + URLEncoder.encode(this.sessionId, "UTF-8");
        }
        return prefix;
    }
}

