/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.oauth2.sdk.Scope;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestedScopeLookupFunction
extends AbstractAuthorizationRequestLookupFunction<Scope> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedScopeLookupFunction.class);

    @Override
    @Nullable
    protected Scope doLookup(@Nonnull AuthorizationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("scope") != null) {
                return Scope.parse((String)requestObject.getJWTClaimsSet().getStringClaim("scope"));
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse scope from request object scope value");
            return null;
        }
        Scope result = new Scope();
        Scope requestParameterScope = req.getScope();
        if (requestParameterScope != null) {
            result.addAll((Collection)requestParameterScope);
        }
        return this.checkRequestObject(req, isRequestObjectFromPar, "scope", result, new Scope());
    }
}

