/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseMode;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestResponseModeLookupFunction
extends AbstractAuthorizationRequestLookupFunction<ResponseMode> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestResponseModeLookupFunction.class);

    @Override
    @Nullable
    protected ResponseMode doLookup(@Nonnull AuthorizationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("response_mode") != null) {
                Object rMode = requestObject.getJWTClaimsSet().getClaim("response_mode");
                if (rMode instanceof String) {
                    return new ResponseMode((String)rMode);
                }
                this.log.error("response_mode claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse response mode from request object response_mode value");
            return null;
        }
        if (req.getResponseMode() == null) {
            return null;
        }
        return this.checkRequestObject(req, isRequestObjectFromPar, "response_mode", new ResponseMode(req.getResponseMode().getValue()), null);
    }
}

