/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestMaxAgeLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Duration> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestMaxAgeLookupFunction.class);

    @Override
    @Nullable
    protected Duration doLookup(@Nonnull AuthenticationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getIntegerClaim("max_age") != null) {
                return Duration.ofSeconds(requestObject.getJWTClaimsSet().getIntegerClaim("max_age").intValue());
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse state from request object state value");
            return null;
        }
        return req.getMaxAge() == -1 ? null : (Duration)this.checkRequestObject((AuthorizationRequest)req, isRequestObjectFromPar, "max_age", Duration.ofSeconds(req.getMaxAge()), null);
    }
}

