/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestDPoPJktLookupFunction
extends AbstractAuthorizationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestDPoPJktLookupFunction.class);

    @Override
    @Nullable
    protected String doLookup(@Nonnull AuthorizationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("dpop_jkt") != null) {
                Object thumbprint = requestObject.getJWTClaimsSet().getClaim("dpop_jkt");
                if (thumbprint instanceof String) {
                    String string = (String)thumbprint;
                    return string;
                }
                this.log.error("dpop_jkt claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse dpop_jkt from request object dpop_jkt value");
            return null;
        }
        return req.getDPoPJWKThumbprintConfirmation() == null ? null : (String)this.checkRequestObject(req, isRequestObjectFromPar, "dpop_jkt", req.getDPoPJWKThumbprintConfirmation().getValue().toString(), null);
    }
}

