/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCRpInitiatedLogoutAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateRpInitiatedLogoutContext
extends AbstractOIDCRpInitiatedLogoutAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PopulateRpInitiatedLogoutContext.class);
    @Nonnull
    private Predicate<ProfileRequestContext> idTokenHintEnforcedPredicate = PredicateSupport.alwaysFalse();

    public void setIdTokenHintEnforcedPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.idTokenHintEnforcedPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"ID token hint enforced predicate annot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getLogoutRequest().getIDTokenHint() == null && this.idTokenHintEnforcedPredicate.test(profileRequestContext)) {
            this.log.warn("{} No id_token_hint found, even though it's enforced", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingMandatoryIdTokenHint");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        State state;
        JWT requestedIdTokenHint = this.getLogoutRequest().getIDTokenHint();
        OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = this.getRpInitiatedLogoutContext();
        assert (rpInitiatedLogoutContext != null);
        if (requestedIdTokenHint != null) {
            rpInitiatedLogoutContext.setRequestedIdTokenHint(requestedIdTokenHint);
            if (!(requestedIdTokenHint instanceof EncryptedJWT)) {
                this.log.debug("{} ID token hint is not encrypted, setting it to processedIdTokenHint.", (Object)this.getLogPrefix());
                rpInitiatedLogoutContext.setProcessedIdTokenHint(requestedIdTokenHint);
            }
        }
        rpInitiatedLogoutContext.setLogoutHint(StringSupport.trimOrNull((String)this.getLogoutRequest().getLogoutHint()));
        rpInitiatedLogoutContext.setPostLogoutRedirectUri(this.getLogoutRequest().getPostLogoutRedirectionURI());
        ClientID clientId = this.getLogoutRequest().getClientID();
        if (clientId != null) {
            rpInitiatedLogoutContext.setRequestedClientId(clientId.getValue());
        }
        if ((state = this.getLogoutRequest().getState()) != null) {
            rpInitiatedLogoutContext.setState(state.getValue());
        }
    }
}

