/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeOutboundResponseMessageContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class PopulateLogoutContext
extends InitializeOutboundResponseMessageContext {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(PopulateLogoutContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCLogoutPropagationContext> oidcLogoutContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy;
    @Nullable
    private OIDCClientInformation clientInformation;

    public PopulateLogoutContext() {
        Function olccs = new ChildContextLookup(OIDCLogoutPropagationContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (olccs != null);
        this.oidcLogoutContextCreationStrategy = olccs;
        Function omcls = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
        assert (omcls != null);
        this.oidcMetadataContextLookupStrategy = omcls;
    }

    public void setOidcLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, OIDCLogoutPropagationContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcLogoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"The OIDC logout context creation strategy cannot be null");
    }

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The OIDC metadata context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCMetadataContext oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcMetadataContext == null || oidcMetadataContext.getClientInformation() == null) {
            log.error("{} Could not find OIDC client metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.clientInformation = oidcMetadataContext.getClientInformation();
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doExecute(profileRequestContext);
        OIDCLogoutPropagationContext logoutContext = this.oidcLogoutContextCreationStrategy.apply(profileRequestContext);
        if (logoutContext == null) {
            log.error("{} Unable to locate/create OIDCLogoutContext to populate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        assert (this.clientInformation != null);
        OIDCClientMetadata metadata = this.clientInformation.getOIDCMetadata();
        logoutContext.setBackChannelLogoutUri(metadata.getBackChannelLogoutURI());
        logoutContext.setFrontChannelLogoutUri(metadata.getFrontChannelLogoutURI());
        log.debug("{} Front-channel URI set to {} and back-channel URI set to {}", new Object[]{this.getLogPrefix(), logoutContext.getFrontChannelLogoutUri(), logoutContext.getBackChannelLogoutUri()});
    }
}

