/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.module.impl.PluginIdPModule;
import net.shibboleth.profile.module.AbstractModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class OIDCOPModule
extends PluginIdPModule {
    @Nonnull
    private final String JWK_JAR_FILENAME = "json-web-key-generator-0.8.2-jar-with-dependencies.jar";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OIDCOPModule.class);

    public OIDCOPModule() throws IOException, ModuleException {
        super(OIDCOPModule.class);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Module.ModuleResource, Module.ResourceResult> enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
        Map results = super.enable(moduleContext);
        Path oldJwkJarRelativePath = Path.of("bin", "lib", "json-web-key-generator-0.8.2-jar-with-dependencies.jar");
        Path oldJwkJarFullPath = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(oldJwkJarRelativePath);
        assert (oldJwkJarRelativePath != null);
        try {
            if (Files.deleteIfExists(oldJwkJarFullPath)) {
                this.log.debug("The old JAR file {} was successfully deleted.", (Object)oldJwkJarFullPath);
                AbstractModule.BasicModuleResource oldJwkJarResource = new AbstractModule.BasicModuleResource((AbstractModule)this, "/net/shibboleth/idp/plugin/oidc/op/bin/lib/json-web-key-generator-0.8.2-jar-with-dependencies.jar", oldJwkJarRelativePath, false, false, false, false, false);
                results.put(oldJwkJarResource, Module.ResourceResult.REMOVED);
            }
        }
        catch (IOException e) {
            this.log.warn("The resource {} could not be removed", (Object)oldJwkJarFullPath, (Object)e);
        }
        return results;
    }
}

