/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.id.ClientID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.slf4j.Logger;

public class OIDCRPSessionClientIDLookupFunction
implements ContextDataLookupFunction<MessageContext, ClientID> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCRPSessionClientIDLookupFunction.class);

    @Nullable
    public ClientID apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            this.log.warn("MessageContext cannot be null, return null for ClientID.");
            return null;
        }
        BaseContext parentContext = messageContext.getParent();
        if (parentContext == null) {
            this.log.warn("ProfileRequestContext cannot be null, return null for ClientID.");
            return null;
        }
        LogoutPropagationContext logoutPropagationContext = (LogoutPropagationContext)parentContext.getSubcontext(LogoutPropagationContext.class);
        if (logoutPropagationContext == null) {
            this.log.warn("LogoutPropagationContext cannot be null, return null for ClientID.");
            return null;
        }
        SPSession sPSession = logoutPropagationContext.getSession();
        if (sPSession instanceof OIDCRPSession) {
            OIDCRPSession rpSession = (OIDCRPSession)sPSession;
            ClientID clientID = new ClientID(rpSession.getId());
            this.log.debug("Return ClientID '{}'.", (Object)clientID);
            return clientID;
        }
        this.log.warn("SPSession is null or not of type OIDCRPSession {}, return null for ClientID.", (Object)logoutPropagationContext.getSession());
        return null;
    }
}

