/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;

public class JWTAccessTokenUpdateStrategy
implements BiConsumer<JWT, MessageContext> {
    @Nonnull
    private Function<MessageContext, AccessTokenContext> accessTokenContextLookupStrategy;

    public JWTAccessTokenUpdateStrategy() {
        Function atcls = new ChildContextLookup(AccessTokenContext.class).compose((Function)new ChildContextLookup(OIDCAuthenticationResponseContext.class));
        assert (atcls != null);
        this.accessTokenContextLookupStrategy = atcls;
    }

    @Override
    public void accept(JWT jwt, MessageContext messageContext) {
        if (messageContext == null) {
            return;
        }
        AccessTokenContext tokenCtx = this.accessTokenContextLookupStrategy.apply(messageContext);
        if (tokenCtx == null) {
            return;
        }
        tokenCtx.setJWT(jwt);
    }
}

