/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultUserInfoSigningAlgLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, JWSAlgorithm> {
    @Nullable
    public JWSAlgorithm apply(@Nullable ProfileRequestContext input) {
        if (input == null || input.getInboundMessageContext() == null) {
            return null;
        }
        OIDCMetadataContext ctx = (OIDCMetadataContext)input.ensureInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        if (ctx == null) {
            return null;
        }
        OIDCClientInformation clientInformation = ctx.getClientInformation();
        if (clientInformation != null && clientInformation.getOIDCMetadata() != null) {
            return clientInformation.getOIDCMetadata().getUserInfoJWSAlg();
        }
        return null;
    }
}

