/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.openid.connect.sdk.claims.CodeHash;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultComputeAuthorizationCodeHashFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultComputeAuthorizationCodeHashFunction.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> authorizationCodeLookupStrategy;

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setAuthorizationCodeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.authorizationCodeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthorizationCode lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.securityParametersLookupStrategy == null) {
            throw new ComponentInitializationException("SecurityParameterContext lookup strategy cannot be null");
        }
        if (this.authorizationCodeLookupStrategy == null) {
            throw new ComponentInitializationException("AuthorizationCode lookup strategy cannot be null");
        }
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        String rawCode = this.authorizationCodeLookupStrategy.apply(input);
        if (StringSupport.trimOrNull((String)rawCode) == null) {
            this.log.error("Could not resolve a value for authorization code to calculate the hash value");
            return null;
        }
        AuthorizationCode code = new AuthorizationCode(rawCode);
        SecurityParametersContext securityParameters = this.securityParametersLookupStrategy.apply(input);
        if (securityParameters == null) {
            this.log.error("Could not resolve security parameters for calculating the code hash value");
            return null;
        }
        SignatureSigningParameters signingParameters = securityParameters.getSignatureSigningParameters();
        if (signingParameters != null) {
            CodeHash cHash = CodeHash.compute((AuthorizationCode)code, (JWSAlgorithm)new JWSAlgorithm(signingParameters.getSignatureAlgorithm()), null);
            if (cHash == null || cHash.getValue() == null) {
                this.log.error("Not able to generate c_hash using algorithm {}", (Object)signingParameters.getSignatureAlgorithm());
                return null;
            }
            return cHash.getValue();
        }
        this.log.error("Could not resolve security parameters for calculating the code hash value");
        return null;
    }
}

