/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class ClientInfoAudienceLookupFunction
implements ContextDataLookupFunction<OIDCMetadataContext, List<String>> {
    @Nullable
    @NonnullElements
    private List<String> defaultAudience;

    public void setDefaultAudience(@Nullable @NonnullElements Collection<String> audience) {
        this.defaultAudience = List.copyOf(StringSupport.normalizeStringCollection(audience));
    }

    @Nullable
    @NonnullElements
    public List<String> apply(@Nullable OIDCMetadataContext input) {
        if (input == null) {
            return this.defaultAudience;
        }
        OIDCClientInformation clientInformation = input.getClientInformation();
        if (clientInformation != null) {
            Object obj = clientInformation.getMetadata().getCustomField("audience");
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                ArrayList<String> audience = new ArrayList<String>();
                for (Object val : collection) {
                    if (val instanceof String) {
                        String string = (String)val;
                        audience.add(string);
                        continue;
                    }
                    if (!(val instanceof URI)) continue;
                    URI uri = (URI)val;
                    audience.add(uri.toString());
                }
                return audience;
            }
            if (obj instanceof String) {
                String string = (String)obj;
                return Collections.singletonList(string);
            }
            return null;
        }
        return this.defaultAudience;
    }
}

