/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile;

import com.nimbusds.oauth2.sdk.ErrorObject;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.EventIdToErrorObjectMapping;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class AbstractErrorObjectMapping
extends AbstractIdentifiableInitializableComponent
implements EventIdToErrorObjectMapping {
    @NonnullAfterInit
    @NotEmpty
    private String eventId;
    @NonnullAfterInit
    private ErrorObject errorObject;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (StringSupport.trimOrNull((String)this.eventId) == null) {
            throw new ComponentInitializationException("EventId cannot be null");
        }
        if (this.errorObject == null) {
            throw new ComponentInitializationException("ErrorObject cannot be null");
        }
    }

    public void setEventId(@Nonnull @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.eventId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"EventId cannot be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getEventId() {
        this.checkComponentActive();
        return this.eventId;
    }

    public void setErrorObject(@Nonnull ErrorObject error) {
        this.checkSetterPreconditions();
        this.errorObject = (ErrorObject)Constraint.isNotNull((Object)error, (String)"ErrorObject cannot be null");
    }

    @Override
    @Nonnull
    public ErrorObject getErrorObject() {
        this.checkComponentActive();
        return this.errorObject;
    }
}

