/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class OIDCClientRegistrationResponseMetadataLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, OIDCClientMetadata> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCClientRegistrationResponseMetadataLookupFunction.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class);

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    @Nullable
    public OIDCClientMetadata apply(@Nullable ProfileRequestContext input) {
        if (input == null || input.getOutboundMessageContext() == null) {
            return null;
        }
        OIDCClientRegistrationResponseContext oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(input.getOutboundMessageContext());
        if (oidcResponseCtx != null) {
            return oidcResponseCtx.getClientMetadata();
        }
        this.log.debug("No response OIDCClientMetadata found from the profile request context!");
        return null;
    }
}

