/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.token.DPoPTokenError;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractBuildErrorResponseFromEvent;
import net.shibboleth.oidc.security.jose.SignatureValidationParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;

public class BuildUserInfoErrorResponseFromEvent
extends AbstractBuildErrorResponseFromEvent<UserInfoErrorResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildUserInfoErrorResponseFromEvent.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @NonnullAfterInit
    private List<JWSAlgorithm> algorithmCandidates;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setAlgorithmCandidates(@Nonnull @NotEmpty Collection<String> candidates) {
        List strings = List.copyOf(StringSupport.normalizeStringCollection((Collection)Constraint.isNotEmpty(candidates, (String)"The list of algorihtm candidates cannot be empty")));
        List<JWSAlgorithm> algorithms = strings.stream().map(JWSAlgorithm::parse).toList();
        assert (algorithms != null);
        this.algorithmCandidates = algorithms;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.securityParametersContextLookupStrategy == null) {
            throw new ComponentInitializationException("SecurityParametersContext lookup strategy cannot be null");
        }
    }

    @Override
    protected UserInfoErrorResponse buildErrorResponse(ErrorObject error, ProfileRequestContext profileRequestContext) {
        if (error instanceof DPoPTokenError) {
            DPoPTokenError dpopError = (DPoPTokenError)error;
            this.log.debug("{} DPoP error {}", (Object)this.getLogPrefix(), (Object)dpopError.getCode());
            SecurityParametersContext securityParameters = this.securityParametersContextLookupStrategy.apply(profileRequestContext);
            SignatureValidationParameters validationParameters = securityParameters.getSignatureValidationParameters();
            ArrayList<JWSAlgorithm> algorithms = new ArrayList<JWSAlgorithm>();
            if (validationParameters != null) {
                for (JWSAlgorithm candidate : this.algorithmCandidates) {
                    String algorithmUri;
                    String string = algorithmUri = candidate == null ? null : candidate.toString();
                    if (algorithmUri != null && !AlgorithmSupport.validateAlgorithmURI((String)algorithmUri, (Collection)validationParameters.getIncludedAlgorithms(), (Collection)validationParameters.getExcludedAlgorithms())) {
                        this.log.debug("Algorithm failed include/exclude validation: {}", (Object)candidate);
                        continue;
                    }
                    algorithms.add(candidate);
                }
            }
            return new UserInfoErrorResponse(dpopError.setJWSAlgorithms(Set.of(algorithms.toArray(new JWSAlgorithm[0]))));
        }
        return new UserInfoErrorResponse(error);
    }
}

