/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.session.impl;

import jakarta.json.JsonObject;
import jakarta.json.stream.JsonGenerator;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.session.AbstractSPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafeAfterInit
public class OIDCRPSessionSerializer
extends AbstractSPSessionSerializer {
    @Nonnull
    @NotEmpty
    private static final String LOGOUT_PROP_FIELD = "slop";

    public OIDCRPSessionSerializer(@Nonnull @ParameterName(name="offset") Duration offset) {
        super(offset);
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
        OIDCRPSession oidcRpSession = (OIDCRPSession)instance;
        generator.write("sid", oidcRpSession.getSessionIdentifier());
        generator.write("iss", oidcRpSession.getIssuer());
        generator.write("sub", oidcRpSession.getSubject());
        if (oidcRpSession.getRootTokenIdentifier() != null) {
            generator.write("root_jti", oidcRpSession.getRootTokenIdentifier());
        }
        generator.write(LOGOUT_PROP_FIELD, oidcRpSession.supportsLogoutPropagation());
    }

    @Nonnull
    protected SPSession doDeserialize(@Nonnull JsonObject obj, @Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration) {
        String issuer = Constraint.isNotEmpty((String)obj.getString("iss", null), (String)"Issuer cannot be empty");
        String sessionId = Constraint.isNotEmpty((String)obj.getString("sid", null), (String)"Session ID cannot be empty");
        String subject = Constraint.isNotEmpty((String)obj.getString("sub", null), (String)"Subject cannot be empty");
        return new OIDCRPSession.Builder().serviceId(id).creationInstant(creation).expirationInstant(expiration).issuer(issuer).rootTokenIdentifier(obj.getString("root_jti", null)).sessionIdentifier(sessionId).subject(subject).supportLogoutPropagation(obj.getBoolean(LOGOUT_PROP_FIELD, true)).build();
    }
}

