/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Instant;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl.DPoPProofNonceJWTValidationException;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.profile.config.navigate.DPoPProofNonceGeneratorLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DPoPProofNonceClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DPoPProofNonceClaimsValidator.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nonnull
    private Function<ProfileRequestContext, Function<ProfileRequestContext, String>> nonceGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy;

    public DPoPProofNonceClaimsValidator(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
        this.nonceGeneratorLookupStrategy = new DPoPProofNonceGeneratorLookupFunction();
        this.relyingPartyIdLookupStrategy = new RelyingPartyIdLookupFunction();
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setDpopProofNonceGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<ProfileRequestContext, String>> strategy) {
        this.checkSetterPreconditions();
        this.nonceGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying party ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws DPoPProofNonceJWTValidationException {
        boolean requireNonce = this.nonceGeneratorLookupStrategy.apply(context) != null;
        try {
            String nonce = claims.getStringClaim("nonce");
            if (nonce == null) {
                if (requireNonce) {
                    throw new DPoPProofNonceJWTValidationException("Mandatory value is missing");
                }
                return;
            }
            String unwrapped = this.dataSealer.unwrap(nonce);
            MapType mapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
            Map map = (Map)this.objectMapper.readValue(unwrapped, (JavaType)mapType);
            Instant nonceExp = Instant.ofEpochMilli(Long.parseLong((String)map.get("exp")));
            if (Instant.now().isAfter(nonceExp)) {
                throw new DPoPProofNonceJWTValidationException("Value is expired");
            }
            String rpIdClaim = (String)map.get("rpId");
            if (rpIdClaim == null) {
                throw new DPoPProofNonceJWTValidationException("Relying party ID cannot be resolved from nonce");
            }
            String rpId = this.relyingPartyIdLookupStrategy.apply(context);
            if (rpId == null) {
                this.log.error("Relying party ID cannot be resolved");
                throw new DPoPProofNonceJWTValidationException("Relying party ID cannot be resolved");
            }
            if (!rpIdClaim.equals(rpId)) {
                this.log.warn("Relying party IDs don't match: resolved '{}', nonce contained '{}'", (Object)rpId, (Object)rpIdClaim);
                throw new DPoPProofNonceJWTValidationException("Relying party IDs don't match");
            }
        }
        catch (DataSealerException e) {
            this.log.trace("Could not unwrap the nonce data", (Throwable)e);
            throw new DPoPProofNonceJWTValidationException("Could not unwrap the nonce data");
        }
        catch (JsonProcessingException e) {
            this.log.warn("Could not decode JSON from the unwrapped nonce", (Throwable)e);
            throw new DPoPProofNonceJWTValidationException("Could not decode JSON from unwrapped nonce");
        }
        catch (ParseException e) {
            this.log.trace("Unexpected format for the nonce claim", (Throwable)e);
            throw new DPoPProofNonceJWTValidationException("Unexpected format for the nonce claim");
        }
    }
}

