/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyValidator;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultUnregisteredClientPolicyValidator
extends AbstractInitializableComponent
implements Predicate<Map<String, UnregisteredClientPolicy>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultUnregisteredClientPolicyValidator.class);
    @Nonnull
    private Predicate<Map<String, MetadataPolicy>> syntaxValidator = new DefaultMetadataPolicyValidator();

    public void setSyntaxValidator(@Nonnull Predicate<Map<String, MetadataPolicy>> predicate) {
        this.checkSetterPreconditions();
        this.syntaxValidator = (Predicate)Constraint.isNotNull(predicate, (String)"The syntax validator predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable Map<String, UnregisteredClientPolicy> map) {
        if (!(map != null && !map.isEmpty() && map.containsKey("scope") && map.containsKey("response_type") && map.containsKey("redirect_uri") && map.containsKey("client_id"))) {
            this.log.error("The map of policies is not containing all mandatory items (scope, response_type, redirect_uri, client_id)");
            return false;
        }
        if (!this.syntaxValidator.test(map.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (MetadataPolicy)entry.getValue())))) {
            return false;
        }
        block12: for (String key : map.keySet()) {
            MetadataPolicy policy = (MetadataPolicy)map.get(key);
            switch (key) {
                case "scope": {
                    if (Optional.ofNullable(policy).filter(scopePolicy -> this.preChecksForMandatoryKey((MetadataPolicy)scopePolicy, "scope")).filter(scopePolicy -> this.verifyScopePolicy((MetadataPolicy)scopePolicy)).isPresent()) continue block12;
                    return false;
                }
                case "response_type": {
                    if (Optional.ofNullable(policy).filter(responseType -> this.preChecksForMandatoryKey((MetadataPolicy)responseType, "response_type")).filter(responseType -> this.verifyResponseTypePolicy((MetadataPolicy)responseType)).isPresent()) continue block12;
                    return false;
                }
                case "redirect_uri": {
                    if (Optional.ofNullable(policy).filter(redirectUri -> this.preChecksForMandatoryKey((MetadataPolicy)redirectUri, "redirect_uri")).filter(redirectUri -> this.verifyRedirectUriPolicy((MetadataPolicy)redirectUri)).isPresent()) continue block12;
                    return false;
                }
                case "client_id": {
                    if (Optional.ofNullable(policy).filter(clientId -> this.preChecksForMandatoryKey((MetadataPolicy)clientId, "client_id")).filter(clientId -> this.verifyClientIdPolicy((MetadataPolicy)clientId)).isPresent()) continue block12;
                    return false;
                }
            }
            this.log.warn("Ignorting unsupported item '{}' from the policy", (Object)key);
        }
        return true;
    }

    protected boolean verifyScopePolicy(@Nullable MetadataPolicy policy) {
        if (policy == null) {
            return true;
        }
        if (policy.getOneOfValues() != null || policy.getRegexp() != null) {
            this.log.error("Only 'value' or custom operators should be used together with 'scope' in the policy");
            return false;
        }
        if (!(policy.getValue() instanceof String) && policy.getCustomOperators().isEmpty()) {
            this.log.error("Only string 'value' or custom operators can be specified for 'scope' in the policy");
            return false;
        }
        return true;
    }

    protected boolean verifyResponseTypePolicy(@Nullable MetadataPolicy policy) {
        if (policy == null) {
            return true;
        }
        if (policy.getRegexp() != null || policy.getValue() != null) {
            this.log.error("Only 'one_of' or custom operators should be used together with 'response_type' in the policy");
            return false;
        }
        if ((policy.getOneOfValues() == null || policy.getOneOfValues().isEmpty()) && policy.getCustomOperators().isEmpty()) {
            this.log.error("No 'one_of' or custom operator values specified for 'response_type' in the policy");
            return false;
        }
        return true;
    }

    protected boolean verifyRedirectUriPolicy(@Nullable MetadataPolicy policy) {
        if (policy == null) {
            return true;
        }
        if (policy.getValue() != null) {
            this.log.error("'value' cannot be specified for 'redirect_uri' in the policy");
            return false;
        }
        if ((policy.getOneOfValues() == null || policy.getOneOfValues().isEmpty()) && policy.getRegexp() == null && policy.getCustomOperators().isEmpty()) {
            this.log.error("No 'one_of' or 'regexp' or custom operator values specified for 'redirect_uri' in the policy");
            return false;
        }
        return true;
    }

    protected boolean verifyClientIdPolicy(@Nullable MetadataPolicy policy) {
        if (policy == null) {
            return true;
        }
        if (policy.getValue() != null) {
            this.log.error("'value' cannot be specified for 'client_id' in the policy");
            return false;
        }
        if ((policy.getOneOfValues() == null || policy.getOneOfValues().isEmpty()) && policy.getRegexp() == null && policy.getCustomOperators().isEmpty()) {
            this.log.error("No 'one_of' or 'regexp' or custom operator values specified for 'client_id' in the policy");
            return false;
        }
        return true;
    }

    protected boolean preChecksForMandatoryKey(@Nullable MetadataPolicy policy, String key) {
        if (policy == null) {
            this.log.error("'{}' cannot be unspecified in the policy", (Object)key);
            return false;
        }
        if (policy.isEssential()) {
            this.log.warn("Essential-flag is ignored for the policy item '{}'", (Object)key);
        }
        if (policy.getAdd() != null || policy.getDefaultValue() != null || policy.getSubsetOfValues() != null || policy.getSupersetOfValues() != null) {
            this.log.error("'{}': 'add', default_value', 'subset_of' or 'superset_of' are not supported for policy items", (Object)key);
            return false;
        }
        return true;
    }
}

