/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.AbstractPushedAuthorizationRequestComponent;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultPushedAuthorizationRequestUriSerializationFunction
extends AbstractPushedAuthorizationRequestComponent
implements BiFunction<ProfileRequestContext, Map<String, Object>, URI> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultPushedAuthorizationRequestUriSerializationFunction.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    private boolean xmlSafeIdentifier;
    @Nonnull
    private Duration lifetime;

    public DefaultPushedAuthorizationRequestUriSerializationFunction() {
        Duration fiveMins = Duration.ofMinutes(5L);
        assert (fiveMins != null);
        this.lifetime = fiveMins;
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.xmlSafeIdentifier = false;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setLifetime(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        this.lifetime = (Duration)Constraint.isNotNull((Object)duration, (String)"Lifetime cannot be null");
        Constraint.isTrue((!this.lifetime.isZero() && !this.lifetime.isNegative() ? 1 : 0) != 0, (String)"Lifetime must be greater than 0");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("The data sealer cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public URI apply(@Nullable ProfileRequestContext profileRequestContext, @Nullable Map<String, Object> claimsSet) {
        if (claimsSet != null && !claimsSet.isEmpty()) {
            Instant expiration = Instant.now().plus(this.lifetime);
            IdentifierGenerationStrategy idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
            if (idGenerator == null) {
                this.log.error("Could not resolve ID generator");
                return null;
            }
            HashMap<String, Object> input = new HashMap<String, Object>(claimsSet);
            input.put("jti", idGenerator.generateIdentifier(this.xmlSafeIdentifier));
            assert (expiration != null);
            try {
                String serializedClaimsSet = this.objectMapper.writeValueAsString(input);
                assert (serializedClaimsSet != null);
                String sealedClaimsSet = this.dataSealer.wrap(serializedClaimsSet, expiration);
                String result = "urn:ietf:params:oauth:request_uri:" + sealedClaimsSet;
                return new URI(result);
            }
            catch (JsonProcessingException e) {
                this.log.error("Could not transform the given claims set into JSON", (Throwable)e);
                return null;
            }
            catch (DataSealerException e) {
                this.log.error("Could not encrypt the serialized claims set", (Throwable)e);
                return null;
            }
            catch (URISyntaxException e) {
                this.log.error("Could not build an URI of the sealed claims set", (Throwable)e);
                return null;
            }
        }
        this.log.error("Request URI claims set is null/empty");
        return null;
    }
}

