/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;

public class ValidateRegistrationAccessToken
extends AbstractOIDCRequestAction<OIDCClientRegistrationRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRegistrationAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> registrationClaimsContextCreationStrategy;
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    private RelyingPartyContext relyingPartyContext;
    @Nullable
    @NotEmpty
    private String accessToken;

    public ValidateRegistrationAccessToken() {
        Function rcccs = new ChildContextLookup(OIDCClientRegistrationTokenClaimsContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (rcccs != null);
        this.registrationClaimsContextCreationStrategy = rcccs;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setRegistrationClaimsContextCreationStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registrationClaimsContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationTokenClaimsContext creation strategy cannot be null");
    }

    public void setSealer(@Nonnull DataSealer sealer) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.relyingPartyContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyContext == null) {
            this.log.error("{} No relying party context found, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken() == null || ((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken().getValue() == null) {
            this.log.debug("{} No access token in the request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.accessToken = ((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken().getValue();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RegistrationClaimsSet claimsSet;
        try {
            assert (this.accessToken != null);
            String unwrapped = this.dataSealer.unwrap(this.accessToken);
            this.log.debug("{} Access token unwrapped into {}", (Object)this.getLogPrefix(), (Object)unwrapped);
            claimsSet = (RegistrationClaimsSet)this.objectMapper.readValue(unwrapped, RegistrationClaimsSet.class);
        }
        catch (JsonProcessingException | DataSealerException e) {
            this.log.error("{} Decoding access token failed: {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} Registration access token decoded into {}", (Object)this.getLogPrefix(), (Object)claimsSet);
        if (Instant.now().isAfter(claimsSet.getExpiration())) {
            this.log.error("{} Registration access token exp is in the past {}", (Object)this.getLogPrefix(), (Object)claimsSet.getExpiration());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        String jti = claimsSet.getJti();
        if (jti != null && this.revocationCache.isRevoked(RevocationCacheContexts.REGISTRATION_ACCESS_TOKEN, jti)) {
            this.log.error("{} Registration access token {} has been revoked", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        String relyingPartyId = claimsSet.getRelyingPartyId();
        if (relyingPartyId != null) {
            this.log.debug("{} Registration access token {} carries relying party identifier {}", new Object[]{this.getLogPrefix(), claimsSet.getJti(), relyingPartyId});
            assert (this.relyingPartyContext != null);
            this.relyingPartyContext.setVerified(Boolean.valueOf(true));
            assert (this.relyingPartyContext != null);
            this.relyingPartyContext.setRelyingPartyId(relyingPartyId);
        } else {
            this.log.debug("{} Registration access token {} carries no relying party identifier", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
        }
        this.log.debug("{} Registration access token {} successfully validated", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
        OIDCClientRegistrationTokenClaimsContext registrationClaimsContext = this.registrationClaimsContextCreationStrategy.apply(profileRequestContext);
        if (registrationClaimsContext == null) {
            this.log.error("{} Registration token claims context could not be created, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        registrationClaimsContext.setClaimsSet(claimsSet);
    }
}

