/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestSessionIdLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetSessionIdToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetSessionIdToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> sessionIdLookupStrategy = new TokenRequestSessionIdLookupFunction();

    public void setSessionIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.sessionIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Session ID lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String sessionId = this.sessionIdLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)sessionId) == null) {
            this.log.debug("{} Session id value did not exist", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Setting session id value to {}", (Object)this.getLogPrefix(), (Object)sessionId);
            OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
            assert (oidcResponseContext != null);
            oidcResponseContext.setSessionId(sessionId);
        }
    }
}

