/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class OIDCMetadataLookupHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCMetadataLookupHandler.class);
    @NonnullAfterInit
    private ClientInformationResolver clientResolver;
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy = new DefaultClientIDLookupFunction();

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    public void setClientInformationResolver(@Nonnull ClientInformationResolver resolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientResolver = (ClientInformationResolver)Constraint.isNotNull((Object)resolver, (String)"ClientInformationResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientResolver == null) {
            throw new ComponentInitializationException("ClientInformationResolver cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.ifNotInitializedThrowUninitializedComponentException();
        ClientID clientId = this.clientIDLookupStrategy.apply(messageContext);
        if (clientId == null) {
            this.log.debug("{} No client ID available", (Object)this.getLogPrefix());
            return;
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new ClientIDCriterion(clientId)});
        try {
            OIDCClientInformation clientInformation = (OIDCClientInformation)this.clientResolver.resolveSingle((Object)criteria);
            if (clientInformation == null) {
                this.log.debug("{} No client information returned for {}", (Object)this.getLogPrefix(), (Object)clientId);
                return;
            }
            OIDCMetadataContext oidcCtx = new OIDCMetadataContext();
            oidcCtx.setClientInformation(clientInformation);
            messageContext.addSubcontext((BaseContext)oidcCtx);
            this.log.debug("{} {} added to MessageContext as child of {}", new Object[]{this.getLogPrefix(), OIDCMetadataContext.class.getName(), messageContext.getClass().getName()});
        }
        catch (ResolverException e) {
            this.log.error("{} ResolverException thrown during client information lookup", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

