/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public class CheckRedirectURIs
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckRedirectURIs.class);
    @Nullable
    private OIDCClientRegistrationRequest request;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClientSecurityParameters = params;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " HttpClient cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + "ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.debug("{} No inbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Object message = profileRequestContext.ensureInboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCClientRegistrationRequest)) {
            this.log.debug("{} No inbound message associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.request = (OIDCClientRegistrationRequest)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ApplicationType applicationType;
        assert (this.request != null);
        OIDCClientMetadata metadata = this.request.getOIDCClientMetadata();
        if (metadata == null) {
            this.log.warn("{} No client metadata found in the request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Set redirectURIs = metadata.getRedirectionURIs();
        if (redirectURIs == null || redirectURIs.isEmpty()) {
            this.log.warn("{} No redirection URIs found in the request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingRedirectionURIs");
            return;
        }
        URI sectorIdUri = metadata.getSectorIDURI();
        if (sectorIdUri != null) {
            this.log.debug("{} Found sector_identifier_uri {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            if (!sectorIdUri.getScheme().equals("https")) {
                this.log.warn("{} Invalid sector_identifier_uri scheme {}", (Object)this.getLogPrefix(), (Object)sectorIdUri.getScheme());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            if (!this.verifySectorIdUri(sectorIdUri, redirectURIs)) {
                this.log.warn("{} All redirect URIs are not found from sector_identifier_uri", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
        }
        if ((applicationType = metadata.getApplicationType()) == null || applicationType.equals((Object)ApplicationType.WEB)) {
            Set grantTypes = metadata.getGrantTypes();
            if (grantTypes != null && grantTypes.contains(GrantType.IMPLICIT) && !this.checkScheme(redirectURIs, "https")) {
                this.log.warn("{} Only https-scheme is allowed for implicit flow", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
            if (this.checkForbiddenHostname(redirectURIs, "localhost")) {
                this.log.warn("{} localhost as the hostname in the redirect URI for a Web app", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
        } else {
            if (this.checkForbiddenScheme(redirectURIs, "https")) {
                this.log.warn("{} https-scheme is not allowed for a native application", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
            for (URI redirectUri : redirectURIs) {
                String scheme = redirectUri.getScheme();
                if ("http".equalsIgnoreCase(scheme) && !"localhost".equalsIgnoreCase(redirectUri.getHost())) {
                    this.log.warn("{} http-scheme is only allowed to localhost for a native application", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                    return;
                }
                this.log.debug("{} Accepting a redirect URI {} for a native application", (Object)this.getLogPrefix(), (Object)redirectUri);
            }
        }
        this.log.debug("{} Redirect URIs ({}) checked", (Object)this.getLogPrefix(), (Object)redirectURIs.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean verifySectorIdUri(URI sectorIdUri, Set<URI> redirectURIs) {
        List parsedUris;
        String output;
        ClassicHttpRequest get = ClassicRequestBuilder.get().setUri(sectorIdUri).build();
        assert (get != null);
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)get);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, get, (HttpContext)clientContext);){
            String scheme = get.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
            if (response == null) {
                this.log.error("{} Could not get the sector_identifier_uri contents from {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
                boolean bl = false;
                return bl;
            }
            output = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (URISyntaxException e) {
            this.log.error("{} Could not get the sector_identifier_uri contents from {}", new Object[]{this.getLogPrefix(), sectorIdUri, e});
            return false;
        }
        catch (IOException | ParseException e) {
            this.log.error("{} Could not parse the sector_identifier_uri contents from {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            return false;
        }
        this.log.trace("{} Fetched the following response body: {}", (Object)this.getLogPrefix(), (Object)output);
        try {
            parsedUris = output == null ? Collections.emptyList() : Arrays.asList((URI[])this.objectMapper.readValue(output, URI[].class));
        }
        catch (JsonProcessingException e) {
            this.log.error("{} Could not parse the sector_identifier_uri contents from {}", new Object[]{this.getLogPrefix(), sectorIdUri, e});
            return false;
        }
        if (parsedUris == null) {
            this.log.error("{} sector_identifier_uris contents is empty, no URLs included: {}", (Object)this.getLogPrefix(), (Object)output);
            return false;
        }
        Iterator<URI> iterator = redirectURIs.iterator();
        while (iterator.hasNext()) {
            URI redirectUri = iterator.next();
            if (!parsedUris.contains(redirectUri)) {
                this.log.error("{} Redirect URI {} was not found from the sector_identifier_uris", (Object)this.getLogPrefix(), (Object)redirectUri);
                return false;
            }
            this.log.trace("{} Redirect URI was validated against the sector_identifier_uris", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected boolean checkScheme(Set<URI> redirectURIs, String scheme) {
        for (URI redirectUri : redirectURIs) {
            if (redirectUri.getScheme().equals(scheme)) continue;
            this.log.trace("{} Found '{}' as the scheme in the redirect URI, all should be {}", new Object[]{this.getLogPrefix(), redirectUri.getScheme(), scheme});
            return false;
        }
        return true;
    }

    protected boolean checkForbiddenScheme(Set<URI> redirectURIs, String scheme) {
        for (URI redirectUri : redirectURIs) {
            if (!redirectUri.getScheme().equals(scheme)) continue;
            this.log.trace("{} Found forbidden '{}' as the scheme in the redirect URI {}", new Object[]{this.getLogPrefix(), scheme, redirectUri});
            return true;
        }
        return false;
    }

    protected boolean checkForbiddenHostname(Set<URI> redirectURIs, String hostname) {
        for (URI redirectUri : redirectURIs) {
            if (!hostname.equalsIgnoreCase(redirectUri.getHost())) continue;
            this.log.trace("{} Found forbidden {} as the hostname in the redirect URIs", (Object)this.getLogPrefix(), (Object)hostname);
            return true;
        }
        return false;
    }
}

