/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ValidatedRedirectURILookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractBuildErrorResponseFromEvent;
import net.shibboleth.oidc.profile.config.logic.IncludeIssuerInAuthenticationResponsePredicate;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class BuildAuthenticationErrorResponseFromEvent
extends AbstractBuildErrorResponseFromEvent<AuthenticationErrorResponse> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BuildAuthenticationErrorResponseFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> includeIssuerInResponsePredicate = new IncludeIssuerInAuthenticationResponsePredicate();
    @NonnullAfterInit
    private Function<ProfileRequestContext, ResponseMode> requestedResponseModeLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, State> requestedStateLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, ResponseType> requestedResponseTypeLookupStrategy;
    private Issuer issuer;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setIncludeIssuerInResponsePredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.includeIssuerInResponsePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Include issuer in response predicate cannot be null");
    }

    public void setRequestedResponseModeLookupStrategy(@Nonnull Function<ProfileRequestContext, ResponseMode> strategy) {
        this.checkSetterPreconditions();
        this.requestedResponseModeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRequestedStateLookupStrategy(@Nonnull Function<ProfileRequestContext, State> strategy) {
        this.checkSetterPreconditions();
        this.requestedStateLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRequestedResponseTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, ResponseType> strategy) {
        this.checkSetterPreconditions();
        this.requestedResponseTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.requestedResponseModeLookupStrategy == null) {
            throw new ComponentInitializationException("Response mode lookup strategy cannot be null");
        }
        if (this.requestedStateLookupStrategy == null) {
            throw new ComponentInitializationException("State lookup strategy cannot be null");
        }
        if (this.requestedResponseTypeLookupStrategy == null) {
            throw new ComponentInitializationException("Response type lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.includeIssuerInResponsePredicate.test(profileRequestContext)) {
            String issValue = this.issuerLookupStrategy.apply(profileRequestContext);
            if (StringSupport.trimOrNull((String)issValue) == null) {
                this.log.error("{} Could not resolve value for issuer even though it's required", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
                return false;
            }
            this.issuer = new Issuer(issValue);
        } else {
            this.issuer = null;
        }
        return true;
    }

    @Override
    protected AuthenticationErrorResponse buildErrorResponse(ErrorObject error, ProfileRequestContext profileRequestContext) {
        URI redirectURI = new ValidatedRedirectURILookupFunction().apply(profileRequestContext);
        if (redirectURI == null) {
            return null;
        }
        ResponseMode defaultResponseMode = this.requestedResponseModeLookupStrategy.apply(profileRequestContext);
        ResponseType responseType = this.requestedResponseTypeLookupStrategy.apply(profileRequestContext);
        ResponseMode responseMode = responseType != null && (responseType.impliesHybridFlow() || responseType.impliesImplicitFlow()) ? (defaultResponseMode == null ? ResponseMode.FRAGMENT : (defaultResponseMode == ResponseMode.QUERY ? ResponseMode.FRAGMENT : defaultResponseMode)) : defaultResponseMode;
        return new AuthenticationErrorResponse(redirectURI, error, this.requestedStateLookupStrategy.apply(profileRequestContext), this.issuer, responseMode);
    }
}

