/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.profile.config.navigate.JWEDataEncryptionAlgorithmsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.JWEKeyTransportEncryptionAlgorithmsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.JWSSignatureAlgorithmsLookupFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddSecurityConfigurationToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddSecurityConfigurationToClientMetadata.class);
    @Nonnull
    private Function<ProfileRequestContext, List<String>> signatureAlgorithmsLookupStrategy = new JWSSignatureAlgorithmsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> dataEncryptionAlgorithmsLookupStrategy = new JWEDataEncryptionAlgorithmsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> keyTransportEncryptionAlgorithmsLookupStrategy = new JWEKeyTransportEncryptionAlgorithmsLookupFunction();
    @Nullable
    private List<String> supportedSigningAlgs;
    @Nullable
    private List<String> supportedEncryptionEncs;
    @Nullable
    private List<String> supportedEncryptionAlgs;

    public void setSignatureAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.signatureAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Signature algorithms lookup strategy cannot be null");
    }

    public void setDataEncryptionAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Data encryption algorithms lookup strategy cannot be null");
    }

    public void setKeyTransportAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.keyTransportEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Key transport encryption algorithms lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        List<String> signingAlgs = this.signatureAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (signingAlgs == null || signingAlgs.isEmpty()) {
            this.log.warn("{} No supported signature validation algorithms resolved", (Object)this.getLogPrefix());
            this.supportedSigningAlgs = CollectionSupport.emptyList();
        } else {
            this.supportedSigningAlgs = signingAlgs;
        }
        List<String> encryptionAlgs = this.keyTransportEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (encryptionAlgs == null || encryptionAlgs.isEmpty()) {
            this.log.warn("{} No supported key transport decryption algorithms resolved", (Object)this.getLogPrefix());
            this.supportedEncryptionAlgs = CollectionSupport.emptyList();
        } else {
            this.supportedEncryptionAlgs = encryptionAlgs;
        }
        List<String> encryptionEncs = this.dataEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (encryptionEncs == null || encryptionEncs.isEmpty()) {
            this.log.warn("{} No supported data decryption algorithms resolved", (Object)this.getLogPrefix());
            this.supportedEncryptionEncs = CollectionSupport.emptyList();
        } else {
            this.supportedEncryptionEncs = encryptionEncs;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EncryptionMethod reqUserInfoEncEnc;
        JWEAlgorithm reqUserInfoEncAlg;
        EncryptionMethod reqIdTokenEncEnc;
        JWEAlgorithm reqIdTokenEncAlg;
        JWSAlgorithm reqIdTokenSigAlg = this.getInputMetadata().getIDTokenJWSAlg();
        if (reqIdTokenSigAlg == null) {
            this.getOutputMetadata().setIDTokenJWSAlg(new JWSAlgorithm("RS256"));
        } else {
            this.getOutputMetadata().setIDTokenJWSAlg(reqIdTokenSigAlg);
        }
        assert (this.supportedSigningAlgs != null);
        if (this.supportedSigningAlgs.contains(this.getOutputMetadata().getIDTokenJWSAlg().getName())) {
            boolean implicitOrHybrid = false;
            if (this.getOutputMetadata().getResponseTypes() != null) {
                for (ResponseType responseType : this.getOutputMetadata().getResponseTypes()) {
                    if (!responseType.impliesHybridFlow() && !responseType.impliesImplicitFlow()) continue;
                    implicitOrHybrid = true;
                    break;
                }
            }
            if (this.getOutputMetadata().getIDTokenJWSAlg().equals((Object)Algorithm.NONE) && implicitOrHybrid) {
                this.log.warn("{} The requested id_token_signed_response_alg 'none' is not supported when implicit or hybrid flow in response type", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        } else {
            this.log.warn("{} The requested id_token_signed_response_alg {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getIDTokenJWSAlg().getName());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        JWSAlgorithm reqUserInfoSigAlg = this.getInputMetadata().getUserInfoJWSAlg();
        if (reqUserInfoSigAlg != null) {
            assert (this.supportedSigningAlgs != null);
            if (this.supportedSigningAlgs.contains(reqUserInfoSigAlg.getName())) {
                this.getOutputMetadata().setUserInfoJWSAlg(reqUserInfoSigAlg);
            } else {
                this.log.warn("{} The requested userinfo_signed_response_alg {} is not supported", (Object)this.getLogPrefix(), (Object)reqUserInfoSigAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if ((reqIdTokenEncAlg = this.getInputMetadata().getIDTokenJWEAlg()) == null != ((reqIdTokenEncEnc = this.getInputMetadata().getIDTokenJWEEnc()) == null)) {
            if (reqIdTokenEncAlg == null) {
                this.log.warn("{} The requested id_token_encrypted_response_alg was not defined even though _enc was", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.debug("{} Using default algorithm for id_token_encrypted_response_alg", (Object)this.getLogPrefix());
            this.getOutputMetadata().setIDTokenJWEEnc(EncryptionMethod.A128CBC_HS256);
            this.getOutputMetadata().setIDTokenJWEAlg(reqIdTokenEncAlg);
        } else {
            this.getOutputMetadata().setIDTokenJWEAlg(this.getInputMetadata().getIDTokenJWEAlg());
            this.getOutputMetadata().setIDTokenJWEEnc(this.getInputMetadata().getIDTokenJWEEnc());
        }
        if (this.getOutputMetadata().getIDTokenJWEAlg() != null) {
            assert (this.supportedEncryptionAlgs != null);
            if (!this.supportedEncryptionAlgs.contains(this.getOutputMetadata().getIDTokenJWEAlg().getName())) {
                this.log.warn("{} The requested id_token_encrypted_response_alg {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getIDTokenJWEAlg());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if (this.getOutputMetadata().getIDTokenJWEEnc() != null) {
            assert (this.supportedEncryptionEncs != null);
            if (!this.supportedEncryptionEncs.contains(this.getOutputMetadata().getIDTokenJWEEnc().getName())) {
                this.log.warn("{} The requested id_token_encrypted_response_enc {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getIDTokenJWEEnc());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if ((reqUserInfoEncAlg = this.getInputMetadata().getUserInfoJWEAlg()) == null != ((reqUserInfoEncEnc = this.getInputMetadata().getUserInfoJWEEnc()) == null)) {
            if (reqUserInfoEncAlg == null) {
                this.log.warn("{} The requested userinfo_encrypted_response_alg was not defined even though _enc was", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.debug("{} Using default algorithm for userinfo_encrypted_response_alg", (Object)this.getLogPrefix());
            this.getOutputMetadata().setUserInfoJWEEnc(EncryptionMethod.A128CBC_HS256);
            this.getOutputMetadata().setUserInfoJWEAlg(reqUserInfoEncAlg);
        } else {
            this.getOutputMetadata().setUserInfoJWEAlg(this.getInputMetadata().getUserInfoJWEAlg());
            this.getOutputMetadata().setUserInfoJWEEnc(this.getInputMetadata().getUserInfoJWEEnc());
        }
        if (this.getOutputMetadata().getUserInfoJWEAlg() != null) {
            assert (this.supportedEncryptionAlgs != null);
            if (!this.supportedEncryptionAlgs.contains(this.getOutputMetadata().getUserInfoJWEAlg().getName())) {
                this.log.warn("{} The requested userinfo_encrypted_response_alg {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getUserInfoJWEAlg());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if (this.getOutputMetadata().getUserInfoJWEEnc() != null) {
            assert (this.supportedEncryptionEncs != null);
            if (!this.supportedEncryptionEncs.contains(this.getOutputMetadata().getUserInfoJWEEnc().getName())) {
                this.log.warn("{} The requested userinfo_encrypted_response_enc {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getUserInfoJWEEnc());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
    }
}

