/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.profile.config.navigate.JWEDataEncryptionAlgorithmsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.JWEKeyTransportEncryptionAlgorithmsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.JWSSignatureAlgorithmsLookupFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddRequestObjectSecurityConfigurationToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRequestObjectSecurityConfigurationToClientMetadata.class);
    @Nonnull
    private Function<ProfileRequestContext, List<String>> signatureAlgorithmsLookupStrategy = new JWSSignatureAlgorithmsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> dataEncryptionAlgorithmsLookupStrategy = new JWEDataEncryptionAlgorithmsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> keyTransportEncryptionAlgorithmsLookupStrategy = new JWEKeyTransportEncryptionAlgorithmsLookupFunction();
    private boolean allowSignatureNone;
    @Nullable
    private List<String> supportedSignatureValidationAlgs;
    @Nullable
    private List<String> supportedDecryptionEncs;
    @Nullable
    private List<String> supportedDecryptionAlgs;

    public void setAllowSignatureNone(boolean allow) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.allowSignatureNone = allow;
    }

    public void setSignatureAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.signatureAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Signature algorithms lookup strategy cannot be null");
    }

    public void setDataEncryptionAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Data encryption algorithms lookup strategy cannot be null");
    }

    public void setKeyTransportAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.keyTransportEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Key transport encryption algorithms lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        List<String> validationAlgs = this.signatureAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (validationAlgs == null || validationAlgs.isEmpty()) {
            this.log.warn("{} No supported signature validation algorithms resolved", (Object)this.getLogPrefix());
            this.supportedSignatureValidationAlgs = CollectionSupport.emptyList();
        } else {
            this.supportedSignatureValidationAlgs = validationAlgs;
        }
        List<String> decryptionAlgs = this.keyTransportEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (decryptionAlgs == null || decryptionAlgs.isEmpty()) {
            this.log.warn("{} No supported key transport decryption algorithms resolved", (Object)this.getLogPrefix());
            this.supportedDecryptionAlgs = CollectionSupport.emptyList();
        } else {
            this.supportedDecryptionAlgs = decryptionAlgs;
        }
        List<String> decryptionEncs = this.dataEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (decryptionEncs == null || decryptionEncs.isEmpty()) {
            this.log.warn("{} No supported data decryption algorithms resolved", (Object)this.getLogPrefix());
            this.supportedDecryptionEncs = CollectionSupport.emptyList();
        } else {
            this.supportedDecryptionEncs = decryptionEncs;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EncryptionMethod reqRequestObjectEncEnc;
        JWEAlgorithm reqRequestObjectEncAlg;
        JWSAlgorithm reqRequestObjectSigAlg = this.getInputMetadata().getRequestObjectJWSAlg();
        if (reqRequestObjectSigAlg != null) {
            boolean noneRequestedAndAllowed;
            boolean bl = noneRequestedAndAllowed = "none".equals(reqRequestObjectSigAlg.getName()) && this.allowSignatureNone;
            assert (this.supportedSignatureValidationAlgs != null);
            if (this.supportedSignatureValidationAlgs.contains(reqRequestObjectSigAlg.getName()) || noneRequestedAndAllowed) {
                this.getOutputMetadata().setRequestObjectJWSAlg(reqRequestObjectSigAlg);
            } else {
                this.log.warn("{} The requested request_object_signing_alg {} is not supported", (Object)this.getLogPrefix(), (Object)reqRequestObjectSigAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if ((reqRequestObjectEncAlg = this.getInputMetadata().getRequestObjectJWEAlg()) == null != ((reqRequestObjectEncEnc = this.getInputMetadata().getRequestObjectJWEEnc()) == null)) {
            if (reqRequestObjectEncAlg == null) {
                this.log.warn("{} The requested request_object_encryption_alg was not defined even though _enc was", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.debug("{} Using default algorithm for request_object_encryption_enc", (Object)this.getLogPrefix());
            this.getOutputMetadata().setRequestObjectJWEEnc(EncryptionMethod.A128CBC_HS256);
            this.getOutputMetadata().setRequestObjectJWEAlg(reqRequestObjectEncAlg);
        } else {
            this.getOutputMetadata().setRequestObjectJWEAlg(this.getInputMetadata().getRequestObjectJWEAlg());
            this.getOutputMetadata().setRequestObjectJWEEnc(this.getInputMetadata().getRequestObjectJWEEnc());
        }
        if (this.getOutputMetadata().getRequestObjectJWEAlg() != null) {
            assert (this.supportedDecryptionAlgs != null);
            if (!this.supportedDecryptionAlgs.contains(this.getOutputMetadata().getRequestObjectJWEAlg().getName())) {
                this.log.warn("{} The requested response_object_encryption_alg {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getRequestObjectJWEAlg());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if (this.getOutputMetadata().getRequestObjectJWEEnc() != null) {
            assert (this.supportedDecryptionEncs != null);
            if (!this.supportedDecryptionEncs.contains(this.getOutputMetadata().getRequestObjectJWEEnc().getName())) {
                this.log.warn("{} The requested response_object_encryption_enc {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getRequestObjectJWEEnc());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
    }
}

