/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCSigningResponseAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddAuthorizationCodeHashToIDToken
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthorizationCodeHashToIDToken.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> codeHashCalculationStrategy;

    public void setCodeHashCalculationStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeHashCalculationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authorization code hash calculation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.codeHashCalculationStrategy == null) {
            throw new ComponentInitializationException("Authorization code hash calculation strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        String hashValue = this.codeHashCalculationStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)hashValue) == null) {
            this.log.error("{} Could not produce the authorization code hash value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        IDTokenClaimsSet idTokenClaimsSet = oidcResponseContext.getIDToken();
        assert (idTokenClaimsSet != null);
        this.log.debug("{} Setting authz code hash to id token", (Object)this.getLogPrefix());
        idTokenClaimsSet.setClaim("c_hash", (Object)hashValue);
        this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)idTokenClaimsSet.toJSONObject().toJSONString());
    }
}

