/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCSigningResponseAction;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddAccessTokenHashToIDToken
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAccessTokenHashToIDToken.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        IDTokenClaimsSet idTokenClaimsSet = oidcResponseContext.getIDToken();
        assert (idTokenClaimsSet != null);
        if (oidcResponseContext.getAccessToken() == null) {
            this.log.error("{} No access token to calculate hash on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        SignatureSigningParameters signingParameters = this.getSignatureSigningParameters();
        assert (signingParameters != null);
        AccessTokenHash atHash = AccessTokenHash.compute((AccessToken)oidcResponseContext.getAccessToken(), (JWSAlgorithm)new JWSAlgorithm(signingParameters.getSignatureAlgorithm()), null);
        if (atHash == null || atHash.getValue() == null) {
            this.log.error("{} Not able to generate at_hash using algorithm {}", (Object)this.getLogPrefix(), (Object)signingParameters.getSignatureAlgorithm());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        this.log.debug("{} Setting access token hash to id token", (Object)this.getLogPrefix());
        idTokenClaimsSet.setClaim("at_hash", (Object)atHash.getValue());
        this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)idTokenClaimsSet.toJSONObject().toJSONString());
    }
}

