/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractOIDCSigningResponseAction
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCSigningResponseAction.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy;
    @Nullable
    private SignatureSigningParameters signatureSigningParameters;

    public AbstractOIDCSigningResponseAction() {
        Function splcs = new ChildContextLookup(SecurityParametersContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (splcs != null);
        this.securityParametersLookupStrategy = splcs;
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    @Nullable
    public SignatureSigningParameters getSignatureSigningParameters() {
        return this.signatureSigningParameters;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SecurityParametersContext secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext);
        if (secParamCtx == null) {
            this.log.debug("{} no security parameters context is available", (Object)this.getLogPrefix());
            return false;
        }
        this.signatureSigningParameters = secParamCtx.getSignatureSigningParameters();
        if (this.signatureSigningParameters == null) {
            this.log.debug("{} no signature signing parameters available", (Object)this.getLogPrefix());
            return false;
        }
        assert (this.signatureSigningParameters != null);
        if (this.signatureSigningParameters.getSigningCredential() == null) {
            this.log.debug("{} no signature signing credentials available", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }
}

