/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateRequestObject
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRequestObject.class);
    @Nullable
    private JWT requestObject;
    @NonnullAfterInit
    private ClaimsValidator signedClaimsValidator;
    @NonnullAfterInit
    private ClaimsValidator plainClaimsValidator;
    private boolean parEndpointLogic = false;

    public void setSignedClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.signedClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Signed claims validator cannot be null");
    }

    public void setPlainClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.plainClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Plain claims validator cannot be null");
    }

    public void setParEndpointLogic(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.parEndpointLogic = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.signedClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for signed requests cannot be null");
        }
        if (this.plainClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for plain requests cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.requestObject = oidcResponseContext.getRequestObject();
        if (this.requestObject == null) {
            this.log.debug("{} No request object, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet claimsSet;
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        try {
            assert (this.requestObject != null);
            claimsSet = this.requestObject.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.error("{} Unable to parse request object {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            oidcResponseContext.setRequestObjectFailure(true);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        assert (claimsSet != null);
        AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        if (authorizationRequest == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} Could not resolve AuthorizationRequest message from request", (Object)this.getLogPrefix());
            return;
        }
        if (claimsSet.getClaims().containsKey("client_id") && !authorizationRequest.getClientID().equals((Object)new ClientID((String)claimsSet.getClaim("client_id")))) {
            this.log.error("{} client_id in request object not matching client_id request parameter", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        if (this.requestObject instanceof PlainJWT) {
            JWSAlgorithm requestObjectAlg;
            OIDCClientInformation clientInformation;
            if (oidcResponseContext.isRequestObjectFromPar()) {
                this.log.debug("{} Request object is built by the PAR endpoint and thus already validated", (Object)this.getLogPrefix());
                return;
            }
            if (this.getMetadataContext() == null) {
                this.log.error("{} Request object unsigned, no client metadata", (Object)this.getLogPrefix());
                oidcResponseContext.setRequestObjectFailure(true);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            OIDCMetadataContext metadataContext = this.getMetadataContext();
            if (metadataContext != null && (clientInformation = metadataContext.getClientInformation()) != null && clientInformation.getOIDCMetadata() != null && (requestObjectAlg = clientInformation.getOIDCMetadata().getRequestObjectJWSAlg()) != null && !"none".equals(requestObjectAlg.getName())) {
                this.log.error("{} Request object is not signed, registered alg is {}", (Object)this.getLogPrefix(), (Object)requestObjectAlg.getName());
                oidcResponseContext.setRequestObjectFailure(true);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        if (!this.parEndpointLogic && authorizationRequest instanceof AuthenticationRequest) {
            AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
            ResponseType requestedType = authenticationRequest.getResponseType();
            if (requestedType == null) {
                this.log.error("{} mandatory response_type is missing from the request", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseType");
                return;
            }
            try {
                if (claimsSet.getClaims().containsKey("response_type") && !requestedType.equals((Object)new ResponseType(claimsSet.getStringClaim("response_type").split(" ")))) {
                    this.log.error("{} response_type in request object not matching response_type request parameter", (Object)this.getLogPrefix());
                    oidcResponseContext.setRequestObjectFailure(true);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                    return;
                }
            }
            catch (ParseException e) {
                this.log.error("{} Unable to parse response_type from request object {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                oidcResponseContext.setRequestObjectFailure(true);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        try {
            if (this.requestObject instanceof SignedJWT) {
                this.signedClaimsValidator.validate(claimsSet, profileRequestContext);
            } else {
                this.plainClaimsValidator.validate(claimsSet, profileRequestContext);
            }
        }
        catch (JWTValidationException e) {
            this.log.warn("{} JWT validation failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            oidcResponseContext.setRequestObjectFailure(true);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
    }
}

