/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultDPoPProofThumbprintLookupFunction;
import net.shibboleth.oidc.profile.config.logic.RequireDPoPJktParameterPredicate;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class StoreDPoPProofKeyThumbprint
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StoreDPoPProofKeyThumbprint.class);
    @Nonnull
    private Predicate<ProfileRequestContext> requireDpopJktCondition = new RequireDPoPJktParameterPredicate();
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> jktLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> dpopProofThumbprintLookupStrategy = new DefaultDPoPProofThumbprintLookupFunction();
    private boolean requireJkt;
    @Nullable
    private String jwkThumbprint;

    public void setRequireDpopJktCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requireDpopJktCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setDpopJktLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.jktLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setDpopProofThumbprintLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dpopProofThumbprintLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.jktLookupStrategy == null) {
            throw new ComponentInitializationException("DPoP JKT lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requireJkt = this.requireDpopJktCondition.test(profileRequestContext);
        this.jwkThumbprint = this.jktLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)this.jwkThumbprint) == null && !this.requireJkt) {
            this.log.debug("{} No optional dpop_jkt in request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (StringSupport.trimOrNull((String)this.jwkThumbprint) == null) {
            this.log.warn("{} No dpop_jkt in authorization request even though required by the profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPJktRequired");
            return;
        }
        String proofThumbprint = this.dpopProofThumbprintLookupStrategy.apply(profileRequestContext);
        assert (this.jwkThumbprint != null);
        if (proofThumbprint != null && !this.jwkThumbprint.equals(proofThumbprint)) {
            this.log.warn("{} dpop_jkt in authorization request does not match with the validated thumbprint", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"DPoPProofInvalid");
            return;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setDpopProofJwkThumbprint(this.jwkThumbprint);
        this.log.debug("{} JWK thumbprint successfully stored into the context", (Object)this.getLogPrefix());
    }
}

