/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOAuthAuthorizationRequestAction
extends AbstractOIDCRequestAction<AuthorizationRequest> {
    @Nullable
    private AuthorizationRequest authorizationRequest;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Object request = this.getRequest();
        if (request instanceof AuthorizationRequest) {
            AuthorizationRequest authzRequest;
            this.authorizationRequest = authzRequest = (AuthorizationRequest)request;
        } else if (request instanceof PushedAuthorizationRequest) {
            PushedAuthorizationRequest pushedAuthorizationRequest = (PushedAuthorizationRequest)request;
            this.authorizationRequest = pushedAuthorizationRequest.getAuthorizationRequest();
        }
        return true;
    }

    @Nullable
    public AuthorizationRequest getAuthorizationRequest() {
        return this.authorizationRequest;
    }
}

